// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Alert;
import com.microsoft.graph.models.extensions.SecureScoreControlProfile;
import com.microsoft.graph.models.extensions.SecureScore;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.AlertCollectionResponse;
import com.microsoft.graph.requests.extensions.AlertCollectionPage;
import com.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionResponse;
import com.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionPage;
import com.microsoft.graph.requests.extensions.SecureScoreCollectionResponse;
import com.microsoft.graph.requests.extensions.SecureScoreCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Security.
 */
public class Security extends Entity implements IJsonBackedObject {


    /**
     * The Alerts.
     * Read-only. Nullable.
     */
    @SerializedName("alerts")
    @Expose
    public AlertCollectionPage alerts;

    /**
     * The Secure Score Control Profiles.
     * 
     */
    @SerializedName("secureScoreControlProfiles")
    @Expose
    public SecureScoreControlProfileCollectionPage secureScoreControlProfiles;

    /**
     * The Secure Scores.
     * 
     */
    @SerializedName("secureScores")
    @Expose
    public SecureScoreCollectionPage secureScores;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("alerts")) {
            final AlertCollectionResponse response = new AlertCollectionResponse();
            if (json.has("alerts@odata.nextLink")) {
                response.nextLink = json.get("alerts@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("alerts").toString(), JsonObject[].class);
            final Alert[] array = new Alert[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Alert.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            alerts = new AlertCollectionPage(response, null);
        }

        if (json.has("secureScoreControlProfiles")) {
            final SecureScoreControlProfileCollectionResponse response = new SecureScoreControlProfileCollectionResponse();
            if (json.has("secureScoreControlProfiles@odata.nextLink")) {
                response.nextLink = json.get("secureScoreControlProfiles@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("secureScoreControlProfiles").toString(), JsonObject[].class);
            final SecureScoreControlProfile[] array = new SecureScoreControlProfile[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SecureScoreControlProfile.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            secureScoreControlProfiles = new SecureScoreControlProfileCollectionPage(response, null);
        }

        if (json.has("secureScores")) {
            final SecureScoreCollectionResponse response = new SecureScoreCollectionResponse();
            if (json.has("secureScores@odata.nextLink")) {
                response.nextLink = json.get("secureScores@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("secureScores").toString(), JsonObject[].class);
            final SecureScore[] array = new SecureScore[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SecureScore.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            secureScores = new SecureScoreCollectionPage(response, null);
        }
    }
}
