// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.OpenShiftItem;
import com.microsoft.graph.models.extensions.ChangeTrackedEntity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Open Shift.
 */
public class OpenShift extends ChangeTrackedEntity implements IJsonBackedObject {


    /**
     * The Draft Open Shift.
     * An unpublished open shift.
     */
    @SerializedName("draftOpenShift")
    @Expose
    public OpenShiftItem draftOpenShift;

    /**
     * The Scheduling Group Id.
     * ID for the scheduling group that the open shift belongs to.
     */
    @SerializedName("schedulingGroupId")
    @Expose
    public String schedulingGroupId;

    /**
     * The Shared Open Shift.
     * A published open shift.
     */
    @SerializedName("sharedOpenShift")
    @Expose
    public OpenShiftItem sharedOpenShift;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
