// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DomainDnsRecord;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Dns Srv Record.
 */
public class DomainDnsSrvRecord extends DomainDnsRecord implements IJsonBackedObject {


    /**
     * The Name Target.
     * Value to use when configuring the Target property of the SRV record at the DNS host.
     */
    @SerializedName("nameTarget")
    @Expose
    public String nameTarget;

    /**
     * The Port.
     * Value to use when configuring the port property of the SRV record at the DNS host.
     */
    @SerializedName("port")
    @Expose
    public Integer port;

    /**
     * The Priority.
     * Value to use when configuring the priority property of the SRV record at the DNS host.
     */
    @SerializedName("priority")
    @Expose
    public Integer priority;

    /**
     * The Protocol.
     * Value to use when configuring the protocol property of the SRV record at the DNS host.
     */
    @SerializedName("protocol")
    @Expose
    public String protocol;

    /**
     * The Service.
     * Value to use when configuring the service property of the SRV record at the DNS host.
     */
    @SerializedName("service")
    @Expose
    public String service;

    /**
     * The Weight.
     * Value to use when configuring the weight property of the SRV record at the DNS host.
     */
    @SerializedName("weight")
    @Expose
    public Integer weight;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
