// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DeviceConfigurationAssignment;
import com.microsoft.graph.models.extensions.SettingStateDeviceSummary;
import com.microsoft.graph.models.extensions.DeviceConfigurationDeviceStatus;
import com.microsoft.graph.models.extensions.DeviceConfigurationDeviceOverview;
import com.microsoft.graph.models.extensions.DeviceConfigurationUserStatus;
import com.microsoft.graph.models.extensions.DeviceConfigurationUserOverview;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionResponse;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration.
 */
public class DeviceConfiguration extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * DateTime the object was created.
     */
    @SerializedName("createdDateTime")
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Description.
     * Admin provided description of the Device Configuration.
     */
    @SerializedName("description")
    @Expose
    public String description;

    /**
     * The Display Name.
     * Admin provided name of the device configuration.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Last Modified Date Time.
     * DateTime the object was last modified.
     */
    @SerializedName("lastModifiedDateTime")
    @Expose
    public java.util.Calendar lastModifiedDateTime;

    /**
     * The Version.
     * Version of the device configuration.
     */
    @SerializedName("version")
    @Expose
    public Integer version;

    /**
     * The Assignments.
     * The list of assignments for the device configuration profile.
     */
    @SerializedName("assignments")
    @Expose
    public DeviceConfigurationAssignmentCollectionPage assignments;

    /**
     * The Device Setting State Summaries.
     * Device Configuration Setting State Device Summary
     */
    @SerializedName("deviceSettingStateSummaries")
    @Expose
    public SettingStateDeviceSummaryCollectionPage deviceSettingStateSummaries;

    /**
     * The Device Statuses.
     * Device configuration installation status by device.
     */
    @SerializedName("deviceStatuses")
    @Expose
    public DeviceConfigurationDeviceStatusCollectionPage deviceStatuses;

    /**
     * The Device Status Overview.
     * Device Configuration devices status overview
     */
    @SerializedName("deviceStatusOverview")
    @Expose
    public DeviceConfigurationDeviceOverview deviceStatusOverview;

    /**
     * The User Statuses.
     * Device configuration installation status by user.
     */
    @SerializedName("userStatuses")
    @Expose
    public DeviceConfigurationUserStatusCollectionPage userStatuses;

    /**
     * The User Status Overview.
     * Device Configuration users status overview
     */
    @SerializedName("userStatusOverview")
    @Expose
    public DeviceConfigurationUserOverview userStatusOverview;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("assignments")) {
            final DeviceConfigurationAssignmentCollectionResponse response = new DeviceConfigurationAssignmentCollectionResponse();
            if (json.has("assignments@odata.nextLink")) {
                response.nextLink = json.get("assignments@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("assignments").toString(), JsonObject[].class);
            final DeviceConfigurationAssignment[] array = new DeviceConfigurationAssignment[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceConfigurationAssignment.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            assignments = new DeviceConfigurationAssignmentCollectionPage(response, null);
        }

        if (json.has("deviceSettingStateSummaries")) {
            final SettingStateDeviceSummaryCollectionResponse response = new SettingStateDeviceSummaryCollectionResponse();
            if (json.has("deviceSettingStateSummaries@odata.nextLink")) {
                response.nextLink = json.get("deviceSettingStateSummaries@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("deviceSettingStateSummaries").toString(), JsonObject[].class);
            final SettingStateDeviceSummary[] array = new SettingStateDeviceSummary[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SettingStateDeviceSummary.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            deviceSettingStateSummaries = new SettingStateDeviceSummaryCollectionPage(response, null);
        }

        if (json.has("deviceStatuses")) {
            final DeviceConfigurationDeviceStatusCollectionResponse response = new DeviceConfigurationDeviceStatusCollectionResponse();
            if (json.has("deviceStatuses@odata.nextLink")) {
                response.nextLink = json.get("deviceStatuses@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("deviceStatuses").toString(), JsonObject[].class);
            final DeviceConfigurationDeviceStatus[] array = new DeviceConfigurationDeviceStatus[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceConfigurationDeviceStatus.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            deviceStatuses = new DeviceConfigurationDeviceStatusCollectionPage(response, null);
        }

        if (json.has("userStatuses")) {
            final DeviceConfigurationUserStatusCollectionResponse response = new DeviceConfigurationUserStatusCollectionResponse();
            if (json.has("userStatuses@odata.nextLink")) {
                response.nextLink = json.get("userStatuses@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("userStatuses").toString(), JsonObject[].class);
            final DeviceConfigurationUserStatus[] array = new DeviceConfigurationUserStatus[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceConfigurationUserStatus.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            userStatuses = new DeviceConfigurationUserStatusCollectionPage(response, null);
        }
    }
}
