// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.AttachmentType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attachment Item.
 */
public class AttachmentItem implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Attachment Type.
     * The type of attachment. Possible values are: file, item, reference. Required.
     */
    @SerializedName("attachmentType")
    @Expose
    public AttachmentType attachmentType;

    /**
     * The Content Type.
     * The nature of the data in the attachment. Optional.
     */
    @SerializedName("contentType")
    @Expose
    public String contentType;

    /**
     * The Is Inline.
     * true if the attachment is an inline attachment; otherwise, false. Optional.
     */
    @SerializedName("isInline")
    @Expose
    public Boolean isInline;

    /**
     * The Name.
     * The display name of the attachment. This can be a descriptive string and does not have to be the actual file name. Required.
     */
    @SerializedName("name")
    @Expose
    public String name;

    /**
     * The Size.
     * The length of the attachment in bytes. Required.
     */
    @SerializedName("size")
    @Expose
    public Long size;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
