/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintService;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintServiceCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintServiceCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintServiceCollectionPage;
import com.microsoft.graph.requests.extensions.PrintServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintServiceCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintServiceRequestBuilder;
import java.util.List;

public class PrintServiceCollectionRequest
extends BaseCollectionRequest<PrintServiceCollectionResponse, IPrintServiceCollectionPage>
implements IPrintServiceCollectionRequest {
    public PrintServiceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintServiceCollectionResponse.class, IPrintServiceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintServiceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintServiceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintServiceCollectionPage get() throws ClientException {
        PrintServiceCollectionResponse response = (PrintServiceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintService newPrintService, ICallback<? super PrintService> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintServiceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintService, callback);
    }

    @Override
    public PrintService post(PrintService newPrintService) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintServiceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintService);
    }

    @Override
    public IPrintServiceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintServiceCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintServiceCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintServiceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintServiceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintServiceCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintServiceCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintServiceCollectionPage buildFromResponse(PrintServiceCollectionResponse response) {
        PrintServiceCollectionRequestBuilder builder = response.nextLink != null ? new PrintServiceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintServiceCollectionPage page = new PrintServiceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

