/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationSchoolDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.EducationSchoolDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EducationSchoolDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IEducationSchoolDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationSchoolDeltaCollectionRequest;
import java.util.List;

public class EducationSchoolDeltaCollectionRequest
extends BaseCollectionRequest<EducationSchoolDeltaCollectionResponse, IEducationSchoolDeltaCollectionPage>
implements IEducationSchoolDeltaCollectionRequest {
    public EducationSchoolDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSchoolDeltaCollectionResponse.class, IEducationSchoolDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IEducationSchoolDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EducationSchoolDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationSchoolDeltaCollectionPage get() throws ClientException {
        EducationSchoolDeltaCollectionResponse response = (EducationSchoolDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IEducationSchoolDeltaCollectionPage buildFromResponse(EducationSchoolDeltaCollectionResponse response) {
        EducationSchoolDeltaCollectionRequestBuilder builder = response.nextLink != null ? new EducationSchoolDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationSchoolDeltaCollectionPage page = new EducationSchoolDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IEducationSchoolDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationSchoolDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IEducationSchoolDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IEducationSchoolDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IEducationSchoolDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

