/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationClassDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.EducationClassDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EducationClassDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IEducationClassDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationClassDeltaCollectionRequest;
import java.util.List;

public class EducationClassDeltaCollectionRequest
extends BaseCollectionRequest<EducationClassDeltaCollectionResponse, IEducationClassDeltaCollectionPage>
implements IEducationClassDeltaCollectionRequest {
    public EducationClassDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationClassDeltaCollectionResponse.class, IEducationClassDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IEducationClassDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EducationClassDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationClassDeltaCollectionPage get() throws ClientException {
        EducationClassDeltaCollectionResponse response = (EducationClassDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IEducationClassDeltaCollectionPage buildFromResponse(EducationClassDeltaCollectionResponse response) {
        EducationClassDeltaCollectionRequestBuilder builder = response.nextLink != null ? new EducationClassDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationClassDeltaCollectionPage page = new EducationClassDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IEducationClassDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationClassDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IEducationClassDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IEducationClassDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IEducationClassDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

