/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AgreementFileLocalization;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionPage;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionResponse;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionPage;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionRequest;
import java.util.List;

public class AgreementFileLocalizationCollectionRequest
extends BaseCollectionRequest<AgreementFileLocalizationCollectionResponse, IAgreementFileLocalizationCollectionPage>
implements IAgreementFileLocalizationCollectionRequest {
    public AgreementFileLocalizationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFileLocalizationCollectionResponse.class, IAgreementFileLocalizationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAgreementFileLocalizationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AgreementFileLocalizationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAgreementFileLocalizationCollectionPage get() throws ClientException {
        AgreementFileLocalizationCollectionResponse response = (AgreementFileLocalizationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AgreementFileLocalization newAgreementFileLocalization, ICallback<? super AgreementFileLocalization> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AgreementFileLocalizationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreementFileLocalization, callback);
    }

    @Override
    public AgreementFileLocalization post(AgreementFileLocalization newAgreementFileLocalization) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AgreementFileLocalizationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreementFileLocalization);
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAgreementFileLocalizationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAgreementFileLocalizationCollectionPage buildFromResponse(AgreementFileLocalizationCollectionResponse response) {
        AgreementFileLocalizationCollectionRequestBuilder builder = response.nextLink != null ? new AgreementFileLocalizationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AgreementFileLocalizationCollectionPage page = new AgreementFileLocalizationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

