/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AgreementAcceptance;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionPage;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionResponse;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionPage;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionRequest;
import java.util.List;

public class AgreementAcceptanceCollectionRequest
extends BaseCollectionRequest<AgreementAcceptanceCollectionResponse, IAgreementAcceptanceCollectionPage>
implements IAgreementAcceptanceCollectionRequest {
    public AgreementAcceptanceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementAcceptanceCollectionResponse.class, IAgreementAcceptanceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAgreementAcceptanceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AgreementAcceptanceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAgreementAcceptanceCollectionPage get() throws ClientException {
        AgreementAcceptanceCollectionResponse response = (AgreementAcceptanceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AgreementAcceptance newAgreementAcceptance, ICallback<? super AgreementAcceptance> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AgreementAcceptanceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreementAcceptance, callback);
    }

    @Override
    public AgreementAcceptance post(AgreementAcceptance newAgreementAcceptance) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AgreementAcceptanceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreementAcceptance);
    }

    @Override
    public IAgreementAcceptanceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAgreementAcceptanceCollectionPage buildFromResponse(AgreementAcceptanceCollectionResponse response) {
        AgreementAcceptanceCollectionRequestBuilder builder = response.nextLink != null ? new AgreementAcceptanceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AgreementAcceptanceCollectionPage page = new AgreementAcceptanceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

