/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.gson.JsonObject;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.ISerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseCollectionPage<T1, T2 extends IRequestBuilder>
implements IBaseCollectionPage<T1, T2> {
    private AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);
    private final List<T1> pageContents;
    private final T2 requestBuilder;
    private JsonObject rawObject;
    private ISerializer serializer;

    public BaseCollectionPage(List<T1> pageContents, T2 nextRequestBuilder) {
        this.pageContents = Collections.unmodifiableList(pageContents == null ? new ArrayList() : pageContents);
        this.requestBuilder = nextRequestBuilder;
    }

    public BaseCollectionPage(List<T1> pageContents, T2 nextRequestBuilder, AdditionalDataManager responseAdditionalData) {
        this(pageContents, nextRequestBuilder);
        this.additionalDataManager().putAll(responseAdditionalData);
    }

    @Override
    public T2 getNextPage() {
        return this.requestBuilder;
    }

    @Override
    public List<T1> getCurrentPage() {
        return this.pageContents;
    }

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
    }

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return this.additionalDataManager;
    }
}

