// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TeamworkBot;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Bot Request.
 */
public class TeamworkBotRequest extends BaseRequest implements ITeamworkBotRequest {
	
    /**
     * The request for the TeamworkBot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamworkBotRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamworkBot.class);
    }

    /**
     * Gets the TeamworkBot from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super TeamworkBot> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the TeamworkBot from the service
     *
     * @return the TeamworkBot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamworkBot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super TeamworkBot> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamworkBot with a source
     *
     * @param sourceTeamworkBot the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final TeamworkBot sourceTeamworkBot, final ICallback<? super TeamworkBot> callback) {
        send(HttpMethod.PATCH, callback, sourceTeamworkBot);
    }

    /**
     * Patches this TeamworkBot with a source
     *
     * @param sourceTeamworkBot the source object with updates
     * @return the updated TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamworkBot patch(final TeamworkBot sourceTeamworkBot) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final TeamworkBot newTeamworkBot, final ICallback<? super TeamworkBot> callback) {
        send(HttpMethod.POST, callback, newTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the new object to create
     * @return the created TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamworkBot post(final TeamworkBot newTeamworkBot) throws ClientException {
        return send(HttpMethod.POST, newTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final TeamworkBot newTeamworkBot, final ICallback<? super TeamworkBot> callback) {
        send(HttpMethod.PUT, callback, newTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the object to create/update
     * @return the created TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamworkBot put(final TeamworkBot newTeamworkBot) throws ClientException {
        return send(HttpMethod.PUT, newTeamworkBot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITeamworkBotRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TeamworkBotRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITeamworkBotRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TeamworkBotRequest)this;
     }

}

