// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintService;
import com.microsoft.graph.requests.extensions.IPrintServiceEndpointCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceEndpointRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintServiceEndpointCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintServiceEndpointRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Service Request.
 */
public class PrintServiceRequest extends BaseRequest implements IPrintServiceRequest {
	
    /**
     * The request for the PrintService
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintServiceRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintService.class);
    }

    /**
     * Gets the PrintService from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super PrintService> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the PrintService from the service
     *
     * @return the PrintService from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintService get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super PrintService> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintService with a source
     *
     * @param sourcePrintService the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final PrintService sourcePrintService, final ICallback<? super PrintService> callback) {
        send(HttpMethod.PATCH, callback, sourcePrintService);
    }

    /**
     * Patches this PrintService with a source
     *
     * @param sourcePrintService the source object with updates
     * @return the updated PrintService
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintService patch(final PrintService sourcePrintService) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintService);
    }

    /**
     * Creates a PrintService with a new object
     *
     * @param newPrintService the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final PrintService newPrintService, final ICallback<? super PrintService> callback) {
        send(HttpMethod.POST, callback, newPrintService);
    }

    /**
     * Creates a PrintService with a new object
     *
     * @param newPrintService the new object to create
     * @return the created PrintService
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintService post(final PrintService newPrintService) throws ClientException {
        return send(HttpMethod.POST, newPrintService);
    }

    /**
     * Creates a PrintService with a new object
     *
     * @param newPrintService the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final PrintService newPrintService, final ICallback<? super PrintService> callback) {
        send(HttpMethod.PUT, callback, newPrintService);
    }

    /**
     * Creates a PrintService with a new object
     *
     * @param newPrintService the object to create/update
     * @return the created PrintService
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintService put(final PrintService newPrintService) throws ClientException {
        return send(HttpMethod.PUT, newPrintService);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrintServiceRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrintServiceRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrintServiceRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrintServiceRequest)this;
     }

}

