// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Print;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintConnectorRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintOperationRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintOperationRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintServiceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Request Builder.
 */
public class PrintRequestBuilder extends BaseRequestBuilder implements IPrintRequestBuilder {

    /**
     * The request builder for the Print
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IPrintRequest instance
     */
    public IPrintRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IPrintRequest instance
     */
    public IPrintRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.PrintRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IPrintConnectorCollectionRequestBuilder connectors() {
        return new PrintConnectorCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("connectors"), getClient(), null);
    }

    public IPrintConnectorRequestBuilder connectors(final String id) {
        return new PrintConnectorRequestBuilder(getRequestUrlWithAdditionalSegment("connectors") + "/" + id, getClient(), null);
    }
    public IPrintOperationCollectionRequestBuilder operations() {
        return new PrintOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    public IPrintOperationRequestBuilder operations(final String id) {
        return new PrintOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    public IPrinterCollectionRequestBuilder printers() {
        return new PrinterCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("printers"), getClient(), null);
    }

    public IPrinterRequestBuilder printers(final String id) {
        return new PrinterRequestBuilder(getRequestUrlWithAdditionalSegment("printers") + "/" + id, getClient(), null);
    }
    public IPrintServiceCollectionRequestBuilder services() {
        return new PrintServiceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("services"), getClient(), null);
    }

    public IPrintServiceRequestBuilder services(final String id) {
        return new PrintServiceRequestBuilder(getRequestUrlWithAdditionalSegment("services") + "/" + id, getClient(), null);
    }
    public IPrinterShareCollectionRequestBuilder shares() {
        return new PrinterShareCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("shares"), getClient(), null);
    }

    public IPrinterShareRequestBuilder shares(final String id) {
        return new PrinterShareRequestBuilder(getRequestUrlWithAdditionalSegment("shares") + "/" + id, getClient(), null);
    }
    public IPrintTaskDefinitionCollectionRequestBuilder taskDefinitions() {
        return new PrintTaskDefinitionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinitions"), getClient(), null);
    }

    public IPrintTaskDefinitionRequestBuilder taskDefinitions(final String id) {
        return new PrintTaskDefinitionRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinitions") + "/" + id, getClient(), null);
    }
}
