// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OrganizationalBranding;
import com.microsoft.graph.requests.extensions.IOrganizationalBrandingLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOrganizationalBrandingLocalizationRequestBuilder;
import com.microsoft.graph.requests.extensions.OrganizationalBrandingLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OrganizationalBrandingLocalizationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Request.
 */
public class OrganizationalBrandingRequest extends BaseRequest implements IOrganizationalBrandingRequest {
	
    /**
     * The request for the OrganizationalBranding
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationalBrandingRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrganizationalBranding.class);
    }

    /**
     * Gets the OrganizationalBranding from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super OrganizationalBranding> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OrganizationalBranding from the service
     *
     * @return the OrganizationalBranding from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBranding get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super OrganizationalBranding> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OrganizationalBranding with a source
     *
     * @param sourceOrganizationalBranding the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OrganizationalBranding sourceOrganizationalBranding, final ICallback<? super OrganizationalBranding> callback) {
        send(HttpMethod.PATCH, callback, sourceOrganizationalBranding);
    }

    /**
     * Patches this OrganizationalBranding with a source
     *
     * @param sourceOrganizationalBranding the source object with updates
     * @return the updated OrganizationalBranding
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBranding patch(final OrganizationalBranding sourceOrganizationalBranding) throws ClientException {
        return send(HttpMethod.PATCH, sourceOrganizationalBranding);
    }

    /**
     * Creates a OrganizationalBranding with a new object
     *
     * @param newOrganizationalBranding the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OrganizationalBranding newOrganizationalBranding, final ICallback<? super OrganizationalBranding> callback) {
        send(HttpMethod.POST, callback, newOrganizationalBranding);
    }

    /**
     * Creates a OrganizationalBranding with a new object
     *
     * @param newOrganizationalBranding the new object to create
     * @return the created OrganizationalBranding
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBranding post(final OrganizationalBranding newOrganizationalBranding) throws ClientException {
        return send(HttpMethod.POST, newOrganizationalBranding);
    }

    /**
     * Creates a OrganizationalBranding with a new object
     *
     * @param newOrganizationalBranding the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final OrganizationalBranding newOrganizationalBranding, final ICallback<? super OrganizationalBranding> callback) {
        send(HttpMethod.PUT, callback, newOrganizationalBranding);
    }

    /**
     * Creates a OrganizationalBranding with a new object
     *
     * @param newOrganizationalBranding the object to create/update
     * @return the created OrganizationalBranding
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBranding put(final OrganizationalBranding newOrganizationalBranding) throws ClientException {
        return send(HttpMethod.PUT, newOrganizationalBranding);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOrganizationalBrandingRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (OrganizationalBrandingRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOrganizationalBrandingRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (OrganizationalBrandingRequest)this;
     }

}

