// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartAxis;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Axis Request.
 */
public interface IWorkbookChartAxisRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxis from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookChartAxis> callback);

    /**
     * Gets the WorkbookChartAxis from the service
     *
     * @return the WorkbookChartAxis from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxis get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookChartAxis> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxis with a source
     *
     * @param sourceWorkbookChartAxis the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartAxis sourceWorkbookChartAxis, final ICallback<? super WorkbookChartAxis> callback);

    /**
     * Patches this WorkbookChartAxis with a source
     *
     * @param sourceWorkbookChartAxis the source object with updates
     * @return the updated WorkbookChartAxis
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxis patch(final WorkbookChartAxis sourceWorkbookChartAxis) throws ClientException;

    /**
     * Posts a WorkbookChartAxis with a new object
     *
     * @param newWorkbookChartAxis the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartAxis newWorkbookChartAxis, final ICallback<? super WorkbookChartAxis> callback);

    /**
     * Posts a WorkbookChartAxis with a new object
     *
     * @param newWorkbookChartAxis the new object to create
     * @return the created WorkbookChartAxis
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxis post(final WorkbookChartAxis newWorkbookChartAxis) throws ClientException;

    /**
     * Posts a WorkbookChartAxis with a new object
     *
     * @param newWorkbookChartAxis the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartAxis newWorkbookChartAxis, final ICallback<? super WorkbookChartAxis> callback);

    /**
     * Posts a WorkbookChartAxis with a new object
     *
     * @param newWorkbookChartAxis the object to create/update
     * @return the created WorkbookChartAxis
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxis put(final WorkbookChartAxis newWorkbookChartAxis) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartAxisRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartAxisRequest expand(final String value);

}

