// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Printer;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Printer Request.
 */
public interface IPrinterRequest extends IHttpRequest {

    /**
     * Gets the Printer from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Printer> callback);

    /**
     * Gets the Printer from the service
     *
     * @return the Printer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Printer get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Printer> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Printer with a source
     *
     * @param sourcePrinter the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Printer sourcePrinter, final ICallback<? super Printer> callback);

    /**
     * Patches this Printer with a source
     *
     * @param sourcePrinter the source object with updates
     * @return the updated Printer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Printer patch(final Printer sourcePrinter) throws ClientException;

    /**
     * Posts a Printer with a new object
     *
     * @param newPrinter the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Printer newPrinter, final ICallback<? super Printer> callback);

    /**
     * Posts a Printer with a new object
     *
     * @param newPrinter the new object to create
     * @return the created Printer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Printer post(final Printer newPrinter) throws ClientException;

    /**
     * Posts a Printer with a new object
     *
     * @param newPrinter the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Printer newPrinter, final ICallback<? super Printer> callback);

    /**
     * Posts a Printer with a new object
     *
     * @param newPrinter the object to create/update
     * @return the created Printer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Printer put(final Printer newPrinter) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrinterRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrinterRequest expand(final String value);

}

