// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PrintDocument;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Document Request.
 */
public interface IPrintDocumentRequest extends IHttpRequest {

    /**
     * Gets the PrintDocument from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PrintDocument> callback);

    /**
     * Gets the PrintDocument from the service
     *
     * @return the PrintDocument from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintDocument get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PrintDocument> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PrintDocument with a source
     *
     * @param sourcePrintDocument the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PrintDocument sourcePrintDocument, final ICallback<? super PrintDocument> callback);

    /**
     * Patches this PrintDocument with a source
     *
     * @param sourcePrintDocument the source object with updates
     * @return the updated PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintDocument patch(final PrintDocument sourcePrintDocument) throws ClientException;

    /**
     * Posts a PrintDocument with a new object
     *
     * @param newPrintDocument the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PrintDocument newPrintDocument, final ICallback<? super PrintDocument> callback);

    /**
     * Posts a PrintDocument with a new object
     *
     * @param newPrintDocument the new object to create
     * @return the created PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintDocument post(final PrintDocument newPrintDocument) throws ClientException;

    /**
     * Posts a PrintDocument with a new object
     *
     * @param newPrintDocument the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PrintDocument newPrintDocument, final ICallback<? super PrintDocument> callback);

    /**
     * Posts a PrintDocument with a new object
     *
     * @param newPrintDocument the object to create/update
     * @return the created PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintDocument put(final PrintDocument newPrintDocument) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrintDocumentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrintDocumentRequest expand(final String value);

}

