// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.OrganizationalBrandingLocalization;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Organizational Branding Localization Request.
 */
public interface IOrganizationalBrandingLocalizationRequest extends IHttpRequest {

    /**
     * Gets the OrganizationalBrandingLocalization from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super OrganizationalBrandingLocalization> callback);

    /**
     * Gets the OrganizationalBrandingLocalization from the service
     *
     * @return the OrganizationalBrandingLocalization from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingLocalization get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super OrganizationalBrandingLocalization> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OrganizationalBrandingLocalization with a source
     *
     * @param sourceOrganizationalBrandingLocalization the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final OrganizationalBrandingLocalization sourceOrganizationalBrandingLocalization, final ICallback<? super OrganizationalBrandingLocalization> callback);

    /**
     * Patches this OrganizationalBrandingLocalization with a source
     *
     * @param sourceOrganizationalBrandingLocalization the source object with updates
     * @return the updated OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingLocalization patch(final OrganizationalBrandingLocalization sourceOrganizationalBrandingLocalization) throws ClientException;

    /**
     * Posts a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization, final ICallback<? super OrganizationalBrandingLocalization> callback);

    /**
     * Posts a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the new object to create
     * @return the created OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingLocalization post(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException;

    /**
     * Posts a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization, final ICallback<? super OrganizationalBrandingLocalization> callback);

    /**
     * Posts a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the object to create/update
     * @return the created OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrganizationalBrandingLocalization put(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOrganizationalBrandingLocalizationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOrganizationalBrandingLocalizationRequest expand(final String value);

}

