// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AuthenticationMethodsPolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Authentication Methods Policy Request.
 */
public interface IAuthenticationMethodsPolicyRequest extends IHttpRequest {

    /**
     * Gets the AuthenticationMethodsPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AuthenticationMethodsPolicy> callback);

    /**
     * Gets the AuthenticationMethodsPolicy from the service
     *
     * @return the AuthenticationMethodsPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuthenticationMethodsPolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AuthenticationMethodsPolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AuthenticationMethodsPolicy with a source
     *
     * @param sourceAuthenticationMethodsPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AuthenticationMethodsPolicy sourceAuthenticationMethodsPolicy, final ICallback<? super AuthenticationMethodsPolicy> callback);

    /**
     * Patches this AuthenticationMethodsPolicy with a source
     *
     * @param sourceAuthenticationMethodsPolicy the source object with updates
     * @return the updated AuthenticationMethodsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuthenticationMethodsPolicy patch(final AuthenticationMethodsPolicy sourceAuthenticationMethodsPolicy) throws ClientException;

    /**
     * Posts a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy, final ICallback<? super AuthenticationMethodsPolicy> callback);

    /**
     * Posts a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the new object to create
     * @return the created AuthenticationMethodsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuthenticationMethodsPolicy post(final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy) throws ClientException;

    /**
     * Posts a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy, final ICallback<? super AuthenticationMethodsPolicy> callback);

    /**
     * Posts a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the object to create/update
     * @return the created AuthenticationMethodsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuthenticationMethodsPolicy put(final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAuthenticationMethodsPolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAuthenticationMethodsPolicyRequest expand(final String value);

}

