// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AuthenticationMethodsPolicy;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodConfigurationRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodConfigurationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Methods Policy Request Builder.
 */
public class AuthenticationMethodsPolicyRequestBuilder extends BaseRequestBuilder implements IAuthenticationMethodsPolicyRequestBuilder {

    /**
     * The request builder for the AuthenticationMethodsPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodsPolicyRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IAuthenticationMethodsPolicyRequest instance
     */
    public IAuthenticationMethodsPolicyRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IAuthenticationMethodsPolicyRequest instance
     */
    public IAuthenticationMethodsPolicyRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.AuthenticationMethodsPolicyRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IAuthenticationMethodConfigurationCollectionRequestBuilder authenticationMethodConfigurations() {
        return new AuthenticationMethodConfigurationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationMethodConfigurations"), getClient(), null);
    }

    public IAuthenticationMethodConfigurationRequestBuilder authenticationMethodConfigurations(final String id) {
        return new AuthenticationMethodConfigurationRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationMethodConfigurations") + "/" + id, getClient(), null);
    }
}
