// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.AgreementAcceptanceState;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance.
 */
public class AgreementAcceptance extends Entity implements IJsonBackedObject {


    /**
     * The Agreement File Id.
     * ID of the agreement file accepted by the user.
     */
    @SerializedName(value = "agreementFileId", alternate = {"AgreementFileId"})
    @Expose
    public String agreementFileId;

    /**
     * The Agreement Id.
     * ID of the agreement.
     */
    @SerializedName(value = "agreementId", alternate = {"AgreementId"})
    @Expose
    public String agreementId;

    /**
     * The Device Display Name.
     * The display name of the device used for accepting the agreement.
     */
    @SerializedName(value = "deviceDisplayName", alternate = {"DeviceDisplayName"})
    @Expose
    public String deviceDisplayName;

    /**
     * The Device Id.
     * The unique identifier of the device used for accepting the agreement.
     */
    @SerializedName(value = "deviceId", alternate = {"DeviceId"})
    @Expose
    public String deviceId;

    /**
     * The Device OSType.
     * The operating system used for accepting the agreement.
     */
    @SerializedName(value = "deviceOSType", alternate = {"DeviceOSType"})
    @Expose
    public String deviceOSType;

    /**
     * The Device OSVersion.
     * The operating system version of the device used for accepting the agreement.
     */
    @SerializedName(value = "deviceOSVersion", alternate = {"DeviceOSVersion"})
    @Expose
    public String deviceOSVersion;

    /**
     * The Expiration Date Time.
     * The expiration date time of the acceptance. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
    public java.util.Calendar expirationDateTime;

    /**
     * The Recorded Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName(value = "recordedDateTime", alternate = {"RecordedDateTime"})
    @Expose
    public java.util.Calendar recordedDateTime;

    /**
     * The State.
     * Possible values are: accepted, declined.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
    public AgreementAcceptanceState state;

    /**
     * The User Display Name.
     * Display name of the user when the acceptance was recorded.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
    public String userDisplayName;

    /**
     * The User Email.
     * Email of the user when the acceptance was recorded.
     */
    @SerializedName(value = "userEmail", alternate = {"UserEmail"})
    @Expose
    public String userEmail;

    /**
     * The User Id.
     * ID of the user who accepted the agreement.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
    public String userId;

    /**
     * The User Principal Name.
     * UPN of the user when the acceptance was recorded.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
    public String userPrincipalName;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
