/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookRangeBorder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookRangeBorderCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookRangeBorderCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookRangeBorderCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookRangeBorderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookRangeBorderCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookRangeBorderRequestBuilder;
import java.util.List;

public class WorkbookRangeBorderCollectionRequest
extends BaseCollectionRequest<WorkbookRangeBorderCollectionResponse, IWorkbookRangeBorderCollectionPage>
implements IWorkbookRangeBorderCollectionRequest {
    public WorkbookRangeBorderCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeBorderCollectionResponse.class, IWorkbookRangeBorderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookRangeBorderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookRangeBorderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookRangeBorderCollectionPage get() throws ClientException {
        WorkbookRangeBorderCollectionResponse response = (WorkbookRangeBorderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookRangeBorder newWorkbookRangeBorder, ICallback<WorkbookRangeBorder> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookRangeBorderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookRangeBorder, callback);
    }

    @Override
    public WorkbookRangeBorder post(WorkbookRangeBorder newWorkbookRangeBorder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookRangeBorderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookRangeBorder);
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookRangeBorderCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookRangeBorderCollectionPage buildFromResponse(WorkbookRangeBorderCollectionResponse response) {
        WorkbookRangeBorderCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookRangeBorderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookRangeBorderCollectionPage page = new WorkbookRangeBorderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

