/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ThumbnailSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IThumbnailSetCollectionPage;
import com.microsoft.graph.requests.extensions.IThumbnailSetCollectionRequest;
import com.microsoft.graph.requests.extensions.ThumbnailSetCollectionPage;
import com.microsoft.graph.requests.extensions.ThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThumbnailSetCollectionResponse;
import com.microsoft.graph.requests.extensions.ThumbnailSetRequestBuilder;
import java.util.List;

public class ThumbnailSetCollectionRequest
extends BaseCollectionRequest<ThumbnailSetCollectionResponse, IThumbnailSetCollectionPage>
implements IThumbnailSetCollectionRequest {
    public ThumbnailSetCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThumbnailSetCollectionResponse.class, IThumbnailSetCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IThumbnailSetCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ThumbnailSetCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IThumbnailSetCollectionPage get() throws ClientException {
        ThumbnailSetCollectionResponse response = (ThumbnailSetCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ThumbnailSet newThumbnailSet, ICallback<ThumbnailSet> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ThumbnailSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newThumbnailSet, callback);
    }

    @Override
    public ThumbnailSet post(ThumbnailSet newThumbnailSet) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ThumbnailSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newThumbnailSet);
    }

    @Override
    public IThumbnailSetCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IThumbnailSetCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IThumbnailSetCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IThumbnailSetCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IThumbnailSetCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IThumbnailSetCollectionPage buildFromResponse(ThumbnailSetCollectionResponse response) {
        ThumbnailSetCollectionRequestBuilder builder = response.nextLink != null ? new ThumbnailSetCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ThumbnailSetCollectionPage page = new ThumbnailSetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

