/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Thumbnail;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IThumbnailRequest;
import java.util.List;

public class ThumbnailRequest
extends BaseRequest
implements IThumbnailRequest {
    public ThumbnailRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Thumbnail.class);
    }

    @Override
    public void get(ICallback<Thumbnail> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Thumbnail get() throws ClientException {
        return (Thumbnail)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Thumbnail> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Thumbnail sourceThumbnail, ICallback<Thumbnail> callback) {
        this.send(HttpMethod.PATCH, callback, sourceThumbnail);
    }

    @Override
    public Thumbnail patch(Thumbnail sourceThumbnail) throws ClientException {
        return (Thumbnail)this.send(HttpMethod.PATCH, sourceThumbnail);
    }

    @Override
    public void post(Thumbnail newThumbnail, ICallback<Thumbnail> callback) {
        this.send(HttpMethod.POST, callback, newThumbnail);
    }

    @Override
    public Thumbnail post(Thumbnail newThumbnail) throws ClientException {
        return (Thumbnail)this.send(HttpMethod.POST, newThumbnail);
    }

    @Override
    public void put(Thumbnail newThumbnail, ICallback<Thumbnail> callback) {
        this.send(HttpMethod.PUT, callback, newThumbnail);
    }

    @Override
    public Thumbnail put(Thumbnail newThumbnail) throws ClientException {
        return (Thumbnail)this.send(HttpMethod.PUT, newThumbnail);
    }

    @Override
    public IThumbnailRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IThumbnailRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

