/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SharedDriveItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISharedDriveItemCollectionPage;
import com.microsoft.graph.requests.extensions.ISharedDriveItemCollectionRequest;
import com.microsoft.graph.requests.extensions.SharedDriveItemCollectionPage;
import com.microsoft.graph.requests.extensions.SharedDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SharedDriveItemCollectionResponse;
import com.microsoft.graph.requests.extensions.SharedDriveItemRequestBuilder;
import java.util.List;

public class SharedDriveItemCollectionRequest
extends BaseCollectionRequest<SharedDriveItemCollectionResponse, ISharedDriveItemCollectionPage>
implements ISharedDriveItemCollectionRequest {
    public SharedDriveItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharedDriveItemCollectionResponse.class, ISharedDriveItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISharedDriveItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SharedDriveItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISharedDriveItemCollectionPage get() throws ClientException {
        SharedDriveItemCollectionResponse response = (SharedDriveItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SharedDriveItem newSharedDriveItem, ICallback<SharedDriveItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SharedDriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSharedDriveItem, callback);
    }

    @Override
    public SharedDriveItem post(SharedDriveItem newSharedDriveItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SharedDriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSharedDriveItem);
    }

    @Override
    public ISharedDriveItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISharedDriveItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISharedDriveItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISharedDriveItemCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISharedDriveItemCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISharedDriveItemCollectionPage buildFromResponse(SharedDriveItemCollectionResponse response) {
        SharedDriveItemCollectionRequestBuilder builder = response.nextLink != null ? new SharedDriveItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SharedDriveItemCollectionPage page = new SharedDriveItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

