/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Place;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPlaceCollectionPage;
import com.microsoft.graph.requests.extensions.IPlaceCollectionRequest;
import com.microsoft.graph.requests.extensions.PlaceCollectionPage;
import com.microsoft.graph.requests.extensions.PlaceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PlaceCollectionResponse;
import com.microsoft.graph.requests.extensions.PlaceRequestBuilder;
import java.util.List;

public class PlaceCollectionRequest
extends BaseCollectionRequest<PlaceCollectionResponse, IPlaceCollectionPage>
implements IPlaceCollectionRequest {
    public PlaceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlaceCollectionResponse.class, IPlaceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlaceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PlaceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlaceCollectionPage get() throws ClientException {
        PlaceCollectionResponse response = (PlaceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Place newPlace, ICallback<Place> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlaceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPlace, callback);
    }

    @Override
    public Place post(Place newPlace) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlaceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPlace);
    }

    @Override
    public IPlaceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPlaceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPlaceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPlaceCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPlaceCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPlaceCollectionPage buildFromResponse(PlaceCollectionResponse response) {
        PlaceCollectionRequestBuilder builder = response.nextLink != null ? new PlaceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlaceCollectionPage page = new PlaceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

