/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.MessageRule;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMessageRuleRequest;
import java.util.List;

public class MessageRuleRequest
extends BaseRequest
implements IMessageRuleRequest {
    public MessageRuleRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageRule.class);
    }

    @Override
    public void get(ICallback<MessageRule> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public MessageRule get() throws ClientException {
        return (MessageRule)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<MessageRule> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(MessageRule sourceMessageRule, ICallback<MessageRule> callback) {
        this.send(HttpMethod.PATCH, callback, sourceMessageRule);
    }

    @Override
    public MessageRule patch(MessageRule sourceMessageRule) throws ClientException {
        return (MessageRule)this.send(HttpMethod.PATCH, sourceMessageRule);
    }

    @Override
    public void post(MessageRule newMessageRule, ICallback<MessageRule> callback) {
        this.send(HttpMethod.POST, callback, newMessageRule);
    }

    @Override
    public MessageRule post(MessageRule newMessageRule) throws ClientException {
        return (MessageRule)this.send(HttpMethod.POST, newMessageRule);
    }

    @Override
    public void put(MessageRule newMessageRule, ICallback<MessageRule> callback) {
        this.send(HttpMethod.PUT, callback, newMessageRule);
    }

    @Override
    public MessageRule put(MessageRule newMessageRule) throws ClientException {
        return (MessageRule)this.send(HttpMethod.PUT, newMessageRule);
    }

    @Override
    public IMessageRuleRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMessageRuleRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

