/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MailFolder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMailFolderCollectionPage;
import com.microsoft.graph.requests.extensions.IMailFolderCollectionRequest;
import com.microsoft.graph.requests.extensions.MailFolderCollectionPage;
import com.microsoft.graph.requests.extensions.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MailFolderCollectionResponse;
import com.microsoft.graph.requests.extensions.MailFolderRequestBuilder;
import java.util.List;

public class MailFolderCollectionRequest
extends BaseCollectionRequest<MailFolderCollectionResponse, IMailFolderCollectionPage>
implements IMailFolderCollectionRequest {
    public MailFolderCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MailFolderCollectionResponse.class, IMailFolderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMailFolderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MailFolderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMailFolderCollectionPage get() throws ClientException {
        MailFolderCollectionResponse response = (MailFolderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MailFolder newMailFolder, ICallback<MailFolder> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMailFolder, callback);
    }

    @Override
    public MailFolder post(MailFolder newMailFolder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMailFolder);
    }

    @Override
    public IMailFolderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMailFolderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMailFolderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMailFolderCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMailFolderCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMailFolderCollectionPage buildFromResponse(MailFolderCollectionResponse response) {
        MailFolderCollectionRequestBuilder builder = response.nextLink != null ? new MailFolderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MailFolderCollectionPage page = new MailFolderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

