/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDirectoryObjectRequest;
import java.util.List;

public class DirectoryObjectRequest
extends BaseRequest
implements IDirectoryObjectRequest {
    public DirectoryObjectRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends DirectoryObject> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public DirectoryObjectRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObject.class);
    }

    @Override
    public void get(ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DirectoryObject get() throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DirectoryObject sourceDirectoryObject, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDirectoryObject);
    }

    @Override
    public DirectoryObject patch(DirectoryObject sourceDirectoryObject) throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.PATCH, sourceDirectoryObject);
    }

    @Override
    public void post(DirectoryObject newDirectoryObject, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.POST, callback, newDirectoryObject);
    }

    @Override
    public DirectoryObject post(DirectoryObject newDirectoryObject) throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.POST, newDirectoryObject);
    }

    @Override
    public void put(DirectoryObject newDirectoryObject, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.PUT, callback, newDirectoryObject);
    }

    @Override
    public DirectoryObject put(DirectoryObject newDirectoryObject) throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.PUT, newDirectoryObject);
    }

    @Override
    public IDirectoryObjectRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

