/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DeviceConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationRequest;
import java.util.List;

public class DeviceConfigurationRequest
extends BaseRequest
implements IDeviceConfigurationRequest {
    public DeviceConfigurationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends DeviceConfiguration> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public DeviceConfigurationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfiguration.class);
    }

    @Override
    public void get(ICallback<DeviceConfiguration> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DeviceConfiguration get() throws ClientException {
        return (DeviceConfiguration)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<DeviceConfiguration> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DeviceConfiguration sourceDeviceConfiguration, ICallback<DeviceConfiguration> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDeviceConfiguration);
    }

    @Override
    public DeviceConfiguration patch(DeviceConfiguration sourceDeviceConfiguration) throws ClientException {
        return (DeviceConfiguration)this.send(HttpMethod.PATCH, sourceDeviceConfiguration);
    }

    @Override
    public void post(DeviceConfiguration newDeviceConfiguration, ICallback<DeviceConfiguration> callback) {
        this.send(HttpMethod.POST, callback, newDeviceConfiguration);
    }

    @Override
    public DeviceConfiguration post(DeviceConfiguration newDeviceConfiguration) throws ClientException {
        return (DeviceConfiguration)this.send(HttpMethod.POST, newDeviceConfiguration);
    }

    @Override
    public void put(DeviceConfiguration newDeviceConfiguration, ICallback<DeviceConfiguration> callback) {
        this.send(HttpMethod.PUT, callback, newDeviceConfiguration);
    }

    @Override
    public DeviceConfiguration put(DeviceConfiguration newDeviceConfiguration) throws ClientException {
        return (DeviceConfiguration)this.send(HttpMethod.PUT, newDeviceConfiguration);
    }

    @Override
    public IDeviceConfigurationRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceConfigurationRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

