/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignmentCollectionRequest;
import java.util.List;

public class DeviceCompliancePolicyAssignmentCollectionRequest
extends BaseCollectionRequest<DeviceCompliancePolicyAssignmentCollectionResponse, IDeviceCompliancePolicyAssignmentCollectionPage>
implements IDeviceCompliancePolicyAssignmentCollectionRequest {
    public DeviceCompliancePolicyAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceCompliancePolicyAssignmentCollectionResponse.class, IDeviceCompliancePolicyAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCompliancePolicyAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceCompliancePolicyAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionPage get() throws ClientException {
        DeviceCompliancePolicyAssignmentCollectionResponse response = (DeviceCompliancePolicyAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceCompliancePolicyAssignment newDeviceCompliancePolicyAssignment, ICallback<DeviceCompliancePolicyAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceCompliancePolicyAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceCompliancePolicyAssignment, callback);
    }

    @Override
    public DeviceCompliancePolicyAssignment post(DeviceCompliancePolicyAssignment newDeviceCompliancePolicyAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceCompliancePolicyAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceCompliancePolicyAssignment);
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceCompliancePolicyAssignmentCollectionPage buildFromResponse(DeviceCompliancePolicyAssignmentCollectionResponse response) {
        DeviceCompliancePolicyAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCompliancePolicyAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCompliancePolicyAssignmentCollectionPage page = new DeviceCompliancePolicyAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

