/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceDeviceStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceStatusCollectionRequest;
import java.util.List;

public class DeviceComplianceDeviceStatusCollectionRequest
extends BaseCollectionRequest<DeviceComplianceDeviceStatusCollectionResponse, IDeviceComplianceDeviceStatusCollectionPage>
implements IDeviceComplianceDeviceStatusCollectionRequest {
    public DeviceComplianceDeviceStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceDeviceStatusCollectionResponse.class, IDeviceComplianceDeviceStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceDeviceStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceComplianceDeviceStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionPage get() throws ClientException {
        DeviceComplianceDeviceStatusCollectionResponse response = (DeviceComplianceDeviceStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceDeviceStatus newDeviceComplianceDeviceStatus, ICallback<DeviceComplianceDeviceStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceDeviceStatus, callback);
    }

    @Override
    public DeviceComplianceDeviceStatus post(DeviceComplianceDeviceStatus newDeviceComplianceDeviceStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceDeviceStatus);
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceComplianceDeviceStatusCollectionPage buildFromResponse(DeviceComplianceDeviceStatusCollectionResponse response) {
        DeviceComplianceDeviceStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceDeviceStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceDeviceStatusCollectionPage page = new DeviceComplianceDeviceStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

