/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DefaultManagedAppProtection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionResponse;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDefaultManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IDefaultManagedAppProtectionCollectionRequest;
import java.util.List;

public class DefaultManagedAppProtectionCollectionRequest
extends BaseCollectionRequest<DefaultManagedAppProtectionCollectionResponse, IDefaultManagedAppProtectionCollectionPage>
implements IDefaultManagedAppProtectionCollectionRequest {
    public DefaultManagedAppProtectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DefaultManagedAppProtectionCollectionResponse.class, IDefaultManagedAppProtectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDefaultManagedAppProtectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DefaultManagedAppProtectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDefaultManagedAppProtectionCollectionPage get() throws ClientException {
        DefaultManagedAppProtectionCollectionResponse response = (DefaultManagedAppProtectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DefaultManagedAppProtection newDefaultManagedAppProtection, ICallback<DefaultManagedAppProtection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DefaultManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDefaultManagedAppProtection, callback);
    }

    @Override
    public DefaultManagedAppProtection post(DefaultManagedAppProtection newDefaultManagedAppProtection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DefaultManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDefaultManagedAppProtection);
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDefaultManagedAppProtectionCollectionPage buildFromResponse(DefaultManagedAppProtectionCollectionResponse response) {
        DefaultManagedAppProtectionCollectionRequestBuilder builder = response.nextLink != null ? new DefaultManagedAppProtectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DefaultManagedAppProtectionCollectionPage page = new DefaultManagedAppProtectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

