/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ChatMessage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ChatMessageCollectionPage;
import com.microsoft.graph.requests.extensions.ChatMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ChatMessageCollectionResponse;
import com.microsoft.graph.requests.extensions.ChatMessageRequestBuilder;
import com.microsoft.graph.requests.extensions.IChatMessageCollectionPage;
import com.microsoft.graph.requests.extensions.IChatMessageCollectionRequest;
import java.util.List;

public class ChatMessageCollectionRequest
extends BaseCollectionRequest<ChatMessageCollectionResponse, IChatMessageCollectionPage>
implements IChatMessageCollectionRequest {
    public ChatMessageCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessageCollectionResponse.class, IChatMessageCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IChatMessageCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ChatMessageCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IChatMessageCollectionPage get() throws ClientException {
        ChatMessageCollectionResponse response = (ChatMessageCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ChatMessage newChatMessage, ICallback<ChatMessage> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ChatMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChatMessage, callback);
    }

    @Override
    public ChatMessage post(ChatMessage newChatMessage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChatMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChatMessage);
    }

    @Override
    public IChatMessageCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IChatMessageCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChatMessageCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IChatMessageCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IChatMessageCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IChatMessageCollectionPage buildFromResponse(ChatMessageCollectionResponse response) {
        ChatMessageCollectionRequestBuilder builder = response.nextLink != null ? new ChatMessageCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ChatMessageCollectionPage page = new ChatMessageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

