/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Call;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CallCollectionPage;
import com.microsoft.graph.requests.extensions.CallCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CallCollectionResponse;
import com.microsoft.graph.requests.extensions.CallRequestBuilder;
import com.microsoft.graph.requests.extensions.ICallCollectionPage;
import com.microsoft.graph.requests.extensions.ICallCollectionRequest;
import java.util.List;

public class CallCollectionRequest
extends BaseCollectionRequest<CallCollectionResponse, ICallCollectionPage>
implements ICallCollectionRequest {
    public CallCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallCollectionResponse.class, ICallCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ICallCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CallCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICallCollectionPage get() throws ClientException {
        CallCollectionResponse response = (CallCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Call newCall, ICallback<Call> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CallRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCall, callback);
    }

    @Override
    public Call post(Call newCall) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CallRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCall);
    }

    @Override
    public ICallCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICallCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICallCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICallCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ICallCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ICallCollectionPage buildFromResponse(CallCollectionResponse response) {
        CallCollectionRequestBuilder builder = response.nextLink != null ? new CallCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CallCollectionPage page = new CallCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

