/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.CalendarGroup;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CalendarGroupCollectionPage;
import com.microsoft.graph.requests.extensions.CalendarGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CalendarGroupCollectionResponse;
import com.microsoft.graph.requests.extensions.CalendarGroupRequestBuilder;
import com.microsoft.graph.requests.extensions.ICalendarGroupCollectionPage;
import com.microsoft.graph.requests.extensions.ICalendarGroupCollectionRequest;
import java.util.List;

public class CalendarGroupCollectionRequest
extends BaseCollectionRequest<CalendarGroupCollectionResponse, ICalendarGroupCollectionPage>
implements ICalendarGroupCollectionRequest {
    public CalendarGroupCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CalendarGroupCollectionResponse.class, ICalendarGroupCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ICalendarGroupCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CalendarGroupCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICalendarGroupCollectionPage get() throws ClientException {
        CalendarGroupCollectionResponse response = (CalendarGroupCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(CalendarGroup newCalendarGroup, ICallback<CalendarGroup> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CalendarGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCalendarGroup, callback);
    }

    @Override
    public CalendarGroup post(CalendarGroup newCalendarGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCalendarGroup);
    }

    @Override
    public ICalendarGroupCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICalendarGroupCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICalendarGroupCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICalendarGroupCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ICalendarGroupCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ICalendarGroupCollectionPage buildFromResponse(CalendarGroupCollectionResponse response) {
        CalendarGroupCollectionRequestBuilder builder = response.nextLink != null ? new CalendarGroupCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CalendarGroupCollectionPage page = new CalendarGroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

