/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.Notebook;
import com.microsoft.graph.models.extensions.OnenoteEntityHierarchyModel;
import com.microsoft.graph.models.extensions.OnenotePage;
import com.microsoft.graph.models.extensions.SectionGroup;
import com.microsoft.graph.models.extensions.SectionLinks;
import com.microsoft.graph.requests.extensions.OnenotePageCollectionPage;
import com.microsoft.graph.requests.extensions.OnenotePageCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class OnenoteSection
extends OnenoteEntityHierarchyModel
implements IJsonBackedObject {
    @SerializedName(value="isDefault")
    @Expose
    public Boolean isDefault;
    @SerializedName(value="links")
    @Expose
    public SectionLinks links;
    @SerializedName(value="pagesUrl")
    @Expose
    public String pagesUrl;
    @SerializedName(value="pages")
    @Expose
    public OnenotePageCollectionPage pages;
    @SerializedName(value="parentNotebook")
    @Expose
    public Notebook parentNotebook;
    @SerializedName(value="parentSectionGroup")
    @Expose
    public SectionGroup parentSectionGroup;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("pages")) {
            OnenotePageCollectionResponse response = new OnenotePageCollectionResponse();
            if (json.has("pages@odata.nextLink")) {
                response.nextLink = json.get("pages@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("pages").toString(), JsonObject[].class);
            OnenotePage[] array = new OnenotePage[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), OnenotePage.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.pages = new OnenotePageCollectionPage(response, null);
        }
    }
}

