// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.RemoteAssistancePartner;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Assistance Partner Request.
 */
public class RemoteAssistancePartnerRequest extends BaseRequest implements IRemoteAssistancePartnerRequest {
	
    /**
     * The request for the RemoteAssistancePartner
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RemoteAssistancePartnerRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RemoteAssistancePartner.class);
    }

    /**
     * Gets the RemoteAssistancePartner from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<RemoteAssistancePartner> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the RemoteAssistancePartner from the service
     *
     * @return the RemoteAssistancePartner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RemoteAssistancePartner get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<RemoteAssistancePartner> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RemoteAssistancePartner with a source
     *
     * @param sourceRemoteAssistancePartner the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final RemoteAssistancePartner sourceRemoteAssistancePartner, final ICallback<RemoteAssistancePartner> callback) {
        send(HttpMethod.PATCH, callback, sourceRemoteAssistancePartner);
    }

    /**
     * Patches this RemoteAssistancePartner with a source
     *
     * @param sourceRemoteAssistancePartner the source object with updates
     * @return the updated RemoteAssistancePartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RemoteAssistancePartner patch(final RemoteAssistancePartner sourceRemoteAssistancePartner) throws ClientException {
        return send(HttpMethod.PATCH, sourceRemoteAssistancePartner);
    }

    /**
     * Creates a RemoteAssistancePartner with a new object
     *
     * @param newRemoteAssistancePartner the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final RemoteAssistancePartner newRemoteAssistancePartner, final ICallback<RemoteAssistancePartner> callback) {
        send(HttpMethod.POST, callback, newRemoteAssistancePartner);
    }

    /**
     * Creates a RemoteAssistancePartner with a new object
     *
     * @param newRemoteAssistancePartner the new object to create
     * @return the created RemoteAssistancePartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RemoteAssistancePartner post(final RemoteAssistancePartner newRemoteAssistancePartner) throws ClientException {
        return send(HttpMethod.POST, newRemoteAssistancePartner);
    }

    /**
     * Creates a RemoteAssistancePartner with a new object
     *
     * @param newRemoteAssistancePartner the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final RemoteAssistancePartner newRemoteAssistancePartner, final ICallback<RemoteAssistancePartner> callback) {
        send(HttpMethod.PUT, callback, newRemoteAssistancePartner);
    }

    /**
     * Creates a RemoteAssistancePartner with a new object
     *
     * @param newRemoteAssistancePartner the object to create/update
     * @return the created RemoteAssistancePartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RemoteAssistancePartner put(final RemoteAssistancePartner newRemoteAssistancePartner) throws ClientException {
        return send(HttpMethod.PUT, newRemoteAssistancePartner);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IRemoteAssistancePartnerRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (RemoteAssistancePartnerRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IRemoteAssistancePartnerRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (RemoteAssistancePartnerRequest)this;
     }

}

