// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOnenoteSectionCopyToNotebookRequest;
import com.microsoft.graph.requests.extensions.OnenoteSectionCopyToNotebookRequest;
import com.microsoft.graph.models.extensions.OnenoteOperation;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Section Copy To Notebook Request Builder.
 */
public class OnenoteSectionCopyToNotebookRequestBuilder extends BaseActionRequestBuilder implements IOnenoteSectionCopyToNotebookRequestBuilder {

    /**
     * The request builder for this OnenoteSectionCopyToNotebook
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param id the id
     * @param groupId the groupId
     * @param renameAs the renameAs
     * @param siteCollectionId the siteCollectionId
     * @param siteId the siteId
     */
    public OnenoteSectionCopyToNotebookRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String id, final String groupId, final String renameAs, final String siteCollectionId, final String siteId) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("id", id);
        bodyParams.put("groupId", groupId);
        bodyParams.put("renameAs", renameAs);
        bodyParams.put("siteCollectionId", siteCollectionId);
        bodyParams.put("siteId", siteId);
    }

    /**
     * Creates the IOnenoteSectionCopyToNotebookRequest
     *
     * @return the IOnenoteSectionCopyToNotebookRequest instance
     */
    public IOnenoteSectionCopyToNotebookRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IOnenoteSectionCopyToNotebookRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IOnenoteSectionCopyToNotebookRequest instance
     */
    public IOnenoteSectionCopyToNotebookRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        OnenoteSectionCopyToNotebookRequest request = new OnenoteSectionCopyToNotebookRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("id")) {
            request.body.id = getParameter("id");
        }

        if (hasParameter("groupId")) {
            request.body.groupId = getParameter("groupId");
        }

        if (hasParameter("renameAs")) {
            request.body.renameAs = getParameter("renameAs");
        }

        if (hasParameter("siteCollectionId")) {
            request.body.siteCollectionId = getParameter("siteCollectionId");
        }

        if (hasParameter("siteId")) {
            request.body.siteId = getParameter("siteId");
        }

        return request;
    }
}
