// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.RecentNotebook;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.INotebookGetRecentNotebooksCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NotebookGetRecentNotebooksCollectionPage;
import com.microsoft.graph.requests.extensions.NotebookGetRecentNotebooksCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Get Recent Notebooks Collection Page.
 */
public class NotebookGetRecentNotebooksCollectionPage extends BaseCollectionPage<RecentNotebook, INotebookGetRecentNotebooksCollectionRequestBuilder> implements INotebookGetRecentNotebooksCollectionPage {

    /**
     * A collection page for RecentNotebook.
     *
     * @param response The serialized NotebookGetRecentNotebooksCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public NotebookGetRecentNotebooksCollectionPage(final NotebookGetRecentNotebooksCollectionResponse response, final INotebookGetRecentNotebooksCollectionRequestBuilder builder) {
       super(response.value, builder);
    }
}
