// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartDataLabelFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Data Label Format Request.
 */
public interface IWorkbookChartDataLabelFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartDataLabelFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookChartDataLabelFormat> callback);

    /**
     * Gets the WorkbookChartDataLabelFormat from the service
     *
     * @return the WorkbookChartDataLabelFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartDataLabelFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookChartDataLabelFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartDataLabelFormat with a source
     *
     * @param sourceWorkbookChartDataLabelFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartDataLabelFormat sourceWorkbookChartDataLabelFormat, final ICallback<WorkbookChartDataLabelFormat> callback);

    /**
     * Patches this WorkbookChartDataLabelFormat with a source
     *
     * @param sourceWorkbookChartDataLabelFormat the source object with updates
     * @return the updated WorkbookChartDataLabelFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartDataLabelFormat patch(final WorkbookChartDataLabelFormat sourceWorkbookChartDataLabelFormat) throws ClientException;

    /**
     * Posts a WorkbookChartDataLabelFormat with a new object
     *
     * @param newWorkbookChartDataLabelFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartDataLabelFormat newWorkbookChartDataLabelFormat, final ICallback<WorkbookChartDataLabelFormat> callback);

    /**
     * Posts a WorkbookChartDataLabelFormat with a new object
     *
     * @param newWorkbookChartDataLabelFormat the new object to create
     * @return the created WorkbookChartDataLabelFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartDataLabelFormat post(final WorkbookChartDataLabelFormat newWorkbookChartDataLabelFormat) throws ClientException;

    /**
     * Posts a WorkbookChartDataLabelFormat with a new object
     *
     * @param newWorkbookChartDataLabelFormat the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartDataLabelFormat newWorkbookChartDataLabelFormat, final ICallback<WorkbookChartDataLabelFormat> callback);

    /**
     * Posts a WorkbookChartDataLabelFormat with a new object
     *
     * @param newWorkbookChartDataLabelFormat the object to create/update
     * @return the created WorkbookChartDataLabelFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartDataLabelFormat put(final WorkbookChartDataLabelFormat newWorkbookChartDataLabelFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartDataLabelFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartDataLabelFormatRequest expand(final String value);

}

