// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WindowsInformationProtection;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows Information Protection Request.
 */
public interface IWindowsInformationProtectionRequest extends IHttpRequest {

    /**
     * Gets the WindowsInformationProtection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WindowsInformationProtection> callback);

    /**
     * Gets the WindowsInformationProtection from the service
     *
     * @return the WindowsInformationProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtection get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WindowsInformationProtection> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WindowsInformationProtection with a source
     *
     * @param sourceWindowsInformationProtection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WindowsInformationProtection sourceWindowsInformationProtection, final ICallback<WindowsInformationProtection> callback);

    /**
     * Patches this WindowsInformationProtection with a source
     *
     * @param sourceWindowsInformationProtection the source object with updates
     * @return the updated WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtection patch(final WindowsInformationProtection sourceWindowsInformationProtection) throws ClientException;

    /**
     * Posts a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WindowsInformationProtection newWindowsInformationProtection, final ICallback<WindowsInformationProtection> callback);

    /**
     * Posts a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the new object to create
     * @return the created WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtection post(final WindowsInformationProtection newWindowsInformationProtection) throws ClientException;

    /**
     * Posts a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WindowsInformationProtection newWindowsInformationProtection, final ICallback<WindowsInformationProtection> callback);

    /**
     * Posts a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the object to create/update
     * @return the created WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtection put(final WindowsInformationProtection newWindowsInformationProtection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindowsInformationProtectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindowsInformationProtectionRequest expand(final String value);

}

