// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.VppToken;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Vpp Token Request.
 */
public interface IVppTokenRequest extends IHttpRequest {

    /**
     * Gets the VppToken from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<VppToken> callback);

    /**
     * Gets the VppToken from the service
     *
     * @return the VppToken from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    VppToken get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<VppToken> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this VppToken with a source
     *
     * @param sourceVppToken the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final VppToken sourceVppToken, final ICallback<VppToken> callback);

    /**
     * Patches this VppToken with a source
     *
     * @param sourceVppToken the source object with updates
     * @return the updated VppToken
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    VppToken patch(final VppToken sourceVppToken) throws ClientException;

    /**
     * Posts a VppToken with a new object
     *
     * @param newVppToken the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final VppToken newVppToken, final ICallback<VppToken> callback);

    /**
     * Posts a VppToken with a new object
     *
     * @param newVppToken the new object to create
     * @return the created VppToken
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    VppToken post(final VppToken newVppToken) throws ClientException;

    /**
     * Posts a VppToken with a new object
     *
     * @param newVppToken the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final VppToken newVppToken, final ICallback<VppToken> callback);

    /**
     * Posts a VppToken with a new object
     *
     * @param newVppToken the object to create/update
     * @return the created VppToken
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    VppToken put(final VppToken newVppToken) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IVppTokenRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IVppTokenRequest expand(final String value);

}

