// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.User;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the User Request.
 */
public interface IUserRequest extends IHttpRequest {

    /**
     * Gets the User from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<User> callback);

    /**
     * Gets the User from the service
     *
     * @return the User from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    User get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<User> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this User with a source
     *
     * @param sourceUser the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final User sourceUser, final ICallback<User> callback);

    /**
     * Patches this User with a source
     *
     * @param sourceUser the source object with updates
     * @return the updated User
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    User patch(final User sourceUser) throws ClientException;

    /**
     * Posts a User with a new object
     *
     * @param newUser the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final User newUser, final ICallback<User> callback);

    /**
     * Posts a User with a new object
     *
     * @param newUser the new object to create
     * @return the created User
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    User post(final User newUser) throws ClientException;

    /**
     * Posts a User with a new object
     *
     * @param newUser the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final User newUser, final ICallback<User> callback);

    /**
     * Posts a User with a new object
     *
     * @param newUser the object to create/update
     * @return the created User
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    User put(final User newUser) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IUserRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IUserRequest expand(final String value);

}

