// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ListItem;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the List Item Request.
 */
public interface IListItemRequest extends IHttpRequest {

    /**
     * Gets the ListItem from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ListItem> callback);

    /**
     * Gets the ListItem from the service
     *
     * @return the ListItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItem get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ListItem> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ListItem with a source
     *
     * @param sourceListItem the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ListItem sourceListItem, final ICallback<ListItem> callback);

    /**
     * Patches this ListItem with a source
     *
     * @param sourceListItem the source object with updates
     * @return the updated ListItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItem patch(final ListItem sourceListItem) throws ClientException;

    /**
     * Posts a ListItem with a new object
     *
     * @param newListItem the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ListItem newListItem, final ICallback<ListItem> callback);

    /**
     * Posts a ListItem with a new object
     *
     * @param newListItem the new object to create
     * @return the created ListItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItem post(final ListItem newListItem) throws ClientException;

    /**
     * Posts a ListItem with a new object
     *
     * @param newListItem the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ListItem newListItem, final ICallback<ListItem> callback);

    /**
     * Posts a ListItem with a new object
     *
     * @param newListItem the object to create/update
     * @return the created ListItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItem put(final ListItem newListItem) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IListItemRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IListItemRequest expand(final String value);

}

