// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.FileAssessmentRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the File Assessment Request Request.
 */
public interface IFileAssessmentRequestRequest extends IHttpRequest {

    /**
     * Gets the FileAssessmentRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<FileAssessmentRequest> callback);

    /**
     * Gets the FileAssessmentRequest from the service
     *
     * @return the FileAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    FileAssessmentRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<FileAssessmentRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this FileAssessmentRequest with a source
     *
     * @param sourceFileAssessmentRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final FileAssessmentRequest sourceFileAssessmentRequest, final ICallback<FileAssessmentRequest> callback);

    /**
     * Patches this FileAssessmentRequest with a source
     *
     * @param sourceFileAssessmentRequest the source object with updates
     * @return the updated FileAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    FileAssessmentRequest patch(final FileAssessmentRequest sourceFileAssessmentRequest) throws ClientException;

    /**
     * Posts a FileAssessmentRequest with a new object
     *
     * @param newFileAssessmentRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final FileAssessmentRequest newFileAssessmentRequest, final ICallback<FileAssessmentRequest> callback);

    /**
     * Posts a FileAssessmentRequest with a new object
     *
     * @param newFileAssessmentRequest the new object to create
     * @return the created FileAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    FileAssessmentRequest post(final FileAssessmentRequest newFileAssessmentRequest) throws ClientException;

    /**
     * Posts a FileAssessmentRequest with a new object
     *
     * @param newFileAssessmentRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final FileAssessmentRequest newFileAssessmentRequest, final ICallback<FileAssessmentRequest> callback);

    /**
     * Posts a FileAssessmentRequest with a new object
     *
     * @param newFileAssessmentRequest the object to create/update
     * @return the created FileAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    FileAssessmentRequest put(final FileAssessmentRequest newFileAssessmentRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IFileAssessmentRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IFileAssessmentRequestRequest expand(final String value);

}

