// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.EducationUser;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.EducationUser;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Education User With Reference Request.
 */
public interface IEducationUserWithReferenceRequest extends IHttpRequest {

    void post(final EducationUser newEducationUser, final IJsonBackedObject payload, final ICallback<EducationUser> callback);

    EducationUser post(final EducationUser newEducationUser, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<EducationUser> callback);

    EducationUser get() throws ClientException;

	void delete(final ICallback<EducationUser> callback);

	void delete() throws ClientException;

	void patch(final EducationUser sourceEducationUser, final ICallback<EducationUser> callback);

	EducationUser patch(final EducationUser sourceEducationUser) throws ClientException;

    IEducationUserWithReferenceRequest select(final String value);

    IEducationUserWithReferenceRequest expand(final String value);

}
