// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.EducationUser;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Education User Request.
 */
public interface IEducationUserRequest extends IHttpRequest {

    /**
     * Gets the EducationUser from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<EducationUser> callback);

    /**
     * Gets the EducationUser from the service
     *
     * @return the EducationUser from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EducationUser get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<EducationUser> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EducationUser with a source
     *
     * @param sourceEducationUser the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final EducationUser sourceEducationUser, final ICallback<EducationUser> callback);

    /**
     * Patches this EducationUser with a source
     *
     * @param sourceEducationUser the source object with updates
     * @return the updated EducationUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EducationUser patch(final EducationUser sourceEducationUser) throws ClientException;

    /**
     * Posts a EducationUser with a new object
     *
     * @param newEducationUser the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final EducationUser newEducationUser, final ICallback<EducationUser> callback);

    /**
     * Posts a EducationUser with a new object
     *
     * @param newEducationUser the new object to create
     * @return the created EducationUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EducationUser post(final EducationUser newEducationUser) throws ClientException;

    /**
     * Posts a EducationUser with a new object
     *
     * @param newEducationUser the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final EducationUser newEducationUser, final ICallback<EducationUser> callback);

    /**
     * Posts a EducationUser with a new object
     *
     * @param newEducationUser the object to create/update
     * @return the created EducationUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EducationUser put(final EducationUser newEducationUser) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEducationUserRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEducationUserRequest expand(final String value);

}

