// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.EBookInstallSummary;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the EBook Install Summary Request.
 */
public interface IEBookInstallSummaryRequest extends IHttpRequest {

    /**
     * Gets the EBookInstallSummary from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<EBookInstallSummary> callback);

    /**
     * Gets the EBookInstallSummary from the service
     *
     * @return the EBookInstallSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EBookInstallSummary get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<EBookInstallSummary> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EBookInstallSummary with a source
     *
     * @param sourceEBookInstallSummary the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final EBookInstallSummary sourceEBookInstallSummary, final ICallback<EBookInstallSummary> callback);

    /**
     * Patches this EBookInstallSummary with a source
     *
     * @param sourceEBookInstallSummary the source object with updates
     * @return the updated EBookInstallSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EBookInstallSummary patch(final EBookInstallSummary sourceEBookInstallSummary) throws ClientException;

    /**
     * Posts a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final EBookInstallSummary newEBookInstallSummary, final ICallback<EBookInstallSummary> callback);

    /**
     * Posts a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the new object to create
     * @return the created EBookInstallSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EBookInstallSummary post(final EBookInstallSummary newEBookInstallSummary) throws ClientException;

    /**
     * Posts a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final EBookInstallSummary newEBookInstallSummary, final ICallback<EBookInstallSummary> callback);

    /**
     * Posts a EBookInstallSummary with a new object
     *
     * @param newEBookInstallSummary the object to create/update
     * @return the created EBookInstallSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EBookInstallSummary put(final EBookInstallSummary newEBookInstallSummary) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEBookInstallSummaryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEBookInstallSummaryRequest expand(final String value);

}

